# Domain Takip ve Telegram Bildirim Sistemi

Bu sistem, belirli domain'lere giriş yaparak yönlendirme değişikliklerini takip eder ve değişiklik olduğunda Telegram üzerinden bildirim gönderir.

## Kurulum

### 1. Veritabanı Kurulumu

MySQL/MariaDB veritabanınızı oluşturun:

```bash
mysql -u root -p < database.sql
```

Veya phpMyAdmin üzerinden `database.sql` dosyasını import edin.

### 2. Yapılandırma

`config.php` dosyasını düzenleyin:

```php
// Veritabanı ayarları
define('DB_HOST', 'localhost');
define('DB_NAME', 'domain_tracker');
define('DB_USER', 'root');
define('DB_PASS', '');

// Telegram Bot ayarları
define('TELEGRAM_BOT_TOKEN', 'YOUR_BOT_TOKEN_HERE');
define('TELEGRAM_CHAT_ID', 'YOUR_CHAT_ID_HERE');

// t.ly API anahtarı (kısa link genişletme için)
define('TLY_API_KEY', 'YOUR_TLY_API_KEY_HERE');
```

**Telegram Bot Token Nasıl Alınır:**
1. Telegram'da @BotFather'a gidin
2. `/newbot` komutu ile yeni bot oluşturun
3. Bot token'ınızı kopyalayın

**Telegram Chat ID Nasıl Bulunur:**
1. Telegram'da @userinfobot'a gidin
2. Chat ID'nizi öğrenin
3. Kanal için: Kanalı @RawDataBot'a ekleyin ve chat ID'yi alın

**Not:** Artık chat ID'yi manuel girmenize gerek yok! Botu kanala eklediğinizde otomatik olarak kaydedilecektir.

**t.ly API Anahtarı Nasıl Alınır:**
1. t.ly hesabınıza giriş yapın
2. Dashboard > API bölümüne gidin
3. Yeni bir API anahtarı oluşturun
4. `config.php` dosyasındaki `TLY_API_KEY` alanına ekleyin veya admin panelinde `settings` tablosuna kaydedin

### 3. Python Domain İzleme Servisi

PHP cron yerine Python ile domainleri takip etmek isterseniz `domain_monitor.py` scriptini kullanabilirsiniz.

Kurulum:
```bash
python -m venv venv
venv\Scripts\activate    # Windows
# veya
source venv/bin/activate # Linux / macOS

pip install requests pymysql
```

`domain_monitor.py` dosyasında şu alanları düzenleyin:
- `DB_CONFIG`: Veritabanı bağlantı bilgileri
- `TLY_API_KEY`: t.ly API anahtarınız (t.ly panelinden alabilirsiniz)
- Gerekirse Telegram fallback değerleri

Çalıştırma:
```bash
python domain_monitor.py
```

Script açık olduğu sürece 5 dakikada bir veritabanındaki domainleri kontrol eder, yönlendirme değişirse Telegram üzerinden bildirim gönderir ve veritabanını günceller.

### 3. Webhook Kurulumu (Otomatik Kanal Kaydı İçin)

Botun katıldığı kanal ve grupları otomatik kaydetmek için webhook kurulumu yapın:

1. `setup_webhook.php` dosyasını açın
2. `$webhookUrl` değişkenine webhook URL'inizi yazın (örn: `https://yourdomain.com/webhook.php`)
3. Dosyayı çalıştırın:
   ```bash
   php setup_webhook.php
   ```

**Alternatif:** Manuel webhook kurulumu için:
```bash
curl -X POST "https://api.telegram.org/bot<BOT_TOKEN>/setWebhook?url=https://yourdomain.com/webhook.php"
```

### 4. Admin Paneli

Admin paneline erişmek için:
1. Tarayıcınızda `admin.php` dosyasını açın
2. Varsayılan şifre: `admin123` (İlk girişten sonra değiştirin!)
3. Admin panelinden:
   - Botun katıldığı kanalları görüntüleyebilirsiniz
   - Mesaj gönderilecek aktif kanalı seçebilirsiniz
   - Domain ekleyip silebilirsiniz
   - Admin şifresini değiştirebilirsiniz

### 5. Domain Ekleme

Admin panelinden veya manuel olarak veritabanına ekleyin:

```sql
INSERT INTO domains (domain_url) VALUES ('https://t.ly/vidoadres');
```

### 6. Cron Job Kurulumu

Windows için Task Scheduler veya Linux için crontab kullanarak cron dosyasını çalıştırın:

**Linux/Mac:**
```bash
# Her 5 dakikada bir çalıştır
*/5 * * * * php /path/to/cron.php >> /path/to/cron.log 2>&1
```

**Windows (Task Scheduler):**
1. Task Scheduler'ı açın
2. "Create Basic Task" seçin
3. Trigger: "Daily" veya "When the computer starts"
4. Action: "Start a program"
5. Program: `php.exe` yolunu girin
6. Arguments: `C:\xampp\htdocs\cron.php`

**Manuel Test:**
```bash
php cron.php
```

## Sistem Çalışma Mantığı

1. Cron dosyası çalıştığında veritabanındaki tüm domain'ler kontrol edilir
2. Her domain için HTTP isteği yapılır ve yönlendirilen domain tespit edilir
3. Yönlendirilen domain veritabanına kaydedilir
4. Eğer yönlendirilen domain bir önceki kontrol ile aynıysa işlem yapılmaz
5. Eğer yönlendirilen domain değişmişse:
   - `mesaj.md` dosyasından mesaj template'i okunur
   - Yeni domain mesajda eski domain yerine yazılır
   - Telegram'a mesaj ve butonlar ile birlikte gönderilir
   - Veritabanı güncellenir

## Mesaj Formatı

`mesaj.md` dosyası iki bölümden oluşur:
- **Üst kısım:** Normal mesaj metni (----------------- satırından önce)
- **Alt kısım:** Butonlar (----------------- satırından sonra)

Buton formatı:
- İlk satır: Telegram / Canlı Destek (yan yana 2 yarım buton)
- İkinci satır: Instagram / Twitter (yan yana 2 yarım buton)
- Üçüncü satır: Güncel adres butonu (tek uzun buton)

## Dosya Yapısı

- `config.php` - Veritabanı ve Telegram ayarları
- `database.sql` - Veritabanı yapısı
- `domain_checker.php` - Domain kontrol fonksiyonları
- `telegram_bot.php` - Telegram mesaj gönderme fonksiyonları
- `cron.php` - Ana cron dosyası
- `webhook.php` - Telegram webhook handler (kanal/grup otomatik kayıt)
- `setup_webhook.php` - Webhook kurulum scripti
- `admin.php` - Admin paneli (tek sayfa)
- `mesaj.md` - Mesaj template dosyası
- `README.md` - Bu dosya

## Sorun Giderme

**Veritabanı bağlantı hatası:**
- `config.php` dosyasındaki veritabanı bilgilerini kontrol edin

**Telegram mesajı gönderilmiyor:**
- Bot token'ı kontrol edin
- Admin panelinden aktif kanal seçildiğinden emin olun
- Bot'un kanala ekli olduğundan emin olun
- Bot'un kanalda mesaj gönderme yetkisi olduğundan emin olun

**Kanal otomatik kaydedilmiyor:**
- Webhook'un doğru kurulduğundan emin olun
- `webhook.php` dosyasının erişilebilir olduğundan emin olun
- Botu kanala/grupa ekledikten sonra bir mesaj gönderin veya botu mention edin

**Domain kontrol edilemiyor:**
- PHP'de `curl` extension'ının aktif olduğundan emin olun
- Firewall veya güvenlik ayarlarını kontrol edin

## Log Dosyaları

Hatalar `cron_error.log` dosyasına kaydedilir.

