<?php
/**
 * Webhook Kurulum Scripti
 * Bu dosyayı bir kez çalıştırarak Telegram webhook'unu ayarlayın
 */

require_once 'config.php';

$pdo = getDBConnection();
$botToken = getBotToken($pdo);

if (empty($botToken)) {
    die("Lütfen admin panelinden bot token ayarlayın!\n");
}

// Webhook URL'inizi buraya yazın (örn: https://yourdomain.com/webhook.php)
$webhookUrl = 'https://yourdomain.com/webhook.php';

echo "Telegram Webhook Kurulumu\n";
echo "========================\n\n";

// Mevcut webhook bilgilerini al
$url = "https://api.telegram.org/bot" . $botToken . "/getWebhookInfo";
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$webhookInfo = json_decode($response, true);
if ($webhookInfo['ok']) {
    echo "Mevcut Webhook Bilgileri:\n";
    echo "URL: " . ($webhookInfo['result']['url'] ?? 'Yok') . "\n";
    echo "Pending Updates: " . ($webhookInfo['result']['pending_update_count'] ?? 0) . "\n\n";
}

// Webhook'u ayarla
echo "Webhook ayarlanıyor...\n";
$url = "https://api.telegram.org/bot" . $botToken . "/setWebhook";
$data = [
    'url' => $webhookUrl
];

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$result = json_decode($response, true);

if ($result['ok']) {
    echo "✅ Webhook başarıyla ayarlandı!\n";
    echo "Webhook URL: $webhookUrl\n";
} else {
    echo "❌ Webhook ayarlanamadı!\n";
    echo "Hata: " . ($result['description'] ?? 'Bilinmeyen hata') . "\n";
}

echo "\nNot: Webhook URL'inizi yukarıdaki \$webhookUrl değişkenine yazmayı unutmayın!\n";

