<?php
/**
 * Telegram Bot Webhook Handler
 * Botun katıldığı kanal ve grupları otomatik olarak veritabanına kaydeder
 */

require_once 'config.php';

// Webhook verisini al
$update = json_decode(file_get_contents('php://input'), true);

if (!$update) {
    http_response_code(200);
    exit;
}

try {
    $pdo = getDBConnection();
    
    // Bot token kontrolü (veritabanından al)
    $botToken = getBotToken($pdo);
    if (empty($botToken)) {
        error_log("Telegram bot token ayarlanmamış!");
        http_response_code(200);
        exit;
    }
    
    // Mesaj geldiğinde
    if (isset($update['message'])) {
        $message = $update['message'];
        $chat = $message['chat'] ?? null;
        
        if ($chat) {
            saveChatInfo($pdo, $chat);
        }
    }
    
    // Bot kanala/grupa eklendiğinde
    if (isset($update['my_chat_member'])) {
        $chatMember = $update['my_chat_member'];
        $chat = $chatMember['chat'] ?? null;
        
        if ($chat) {
            saveChatInfo($pdo, $chat);
        }
    }
    
    // Channel post geldiğinde
    if (isset($update['channel_post'])) {
        $channelPost = $update['channel_post'];
        $chat = $channelPost['chat'] ?? null;
        
        if ($chat) {
            saveChatInfo($pdo, $chat);
        }
    }
    
    http_response_code(200);
    
} catch (Exception $e) {
    error_log("Webhook hatası: " . $e->getMessage());
    http_response_code(200); // Telegram'a her zaman 200 dön
}

/**
 * Chat bilgilerini veritabanına kaydeder
 */
function saveChatInfo($pdo, $chat) {
    $chatId = $chat['id'] ?? null;
    $chatTitle = $chat['title'] ?? null;
    $chatType = $chat['type'] ?? null;
    $chatUsername = $chat['username'] ?? null;
    
    if (!$chatId) {
        return;
    }
    
    // Sadece kanal ve grup kaydet (private chat'leri kaydetme)
    if (!in_array($chatType, ['channel', 'group', 'supergroup'])) {
        return;
    }
    
    try {
        $stmt = $pdo->prepare("
            INSERT INTO channels (chat_id, chat_title, chat_type, chat_username, last_activity)
            VALUES (?, ?, ?, ?, NOW())
            ON DUPLICATE KEY UPDATE
                chat_title = COALESCE(?, chat_title),
                chat_type = COALESCE(?, chat_type),
                chat_username = COALESCE(?, chat_username),
                last_activity = NOW()
        ");
        
        $stmt->execute([
            $chatId,
            $chatTitle,
            $chatType,
            $chatUsername,
            $chatTitle,
            $chatType,
            $chatUsername
        ]);
        
    } catch (PDOException $e) {
        error_log("Chat kayıt hatası: " . $e->getMessage());
    }
}

